<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Theme's Color Schemes
 *
 * @filter us_config_style-schemes
 */

return array(
	'1' => array(
		'title' => __( 'White Pink', 'us' ),
		'values' => array(
			'color_body_bg' => '#eee',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#e95095',
			'color_chrome_toolbar' => '#f5f5f5',
			'color_header_top_bg' => 'linear-gradient(0deg,#f5f5f5,#fff)',
			'color_header_top_text' => '#333',
			'color_header_top_text_hover' => '#e95095',
			'color_header_bottom_bg' => '#f5f5f5',
			'color_header_bottom_text' => '#333',
			'color_header_bottom_text_hover' => '#e95095',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#ff6ba9',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#e95095',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#e95095',
			'color_menu_button_bg' => '#e95095',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#7049ba',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#333',
			'color_drop_hover_bg' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#e95095',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#e8e8e8',
			'color_content_heading' => '#1a1a1a',
			'color_content_text' => '#333',
			'color_content_link' => '#e95095',
			'color_content_link_hover' => '#7049ba',
			'color_content_primary' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_content_secondary' => 'linear-gradient(135deg,#7049ba,#e95095)',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#1a1a1a',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#e95095',
			'color_alt_content_link_hover' => '#7049ba',
			'color_alt_content_primary' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_alt_content_secondary' => 'linear-gradient(135deg,#7049ba,#e95095)',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#1a1a1a',
			'color_subfooter_bg_alt' => '#222',
			'color_subfooter_border' => '#282828',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#1a1a1a',
			'color_footer_border' => '#333',
			'color_footer_text' => '#999',
			'color_footer_link' => '#ccc',
			'color_footer_link_hover' => '#fff',
		),
	),
	'2' => array(
		'title' => __( 'White Blue', 'us' ),
		'values' => array(
			'color_body_bg' => '#eee',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#1b98e0',
			'color_chrome_toolbar' => '#f5f5f5',
			'color_header_top_bg' => '#f5f5f5',
			'color_header_top_text' => '#777',
			'color_header_top_text_hover' => '#1b98e0',
			'color_header_bottom_bg' => '#f5f5f5',
			'color_header_bottom_text' => '#777',
			'color_header_bottom_text_hover' => '#1b98e0',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#1b98e0',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#42baff',
			'color_menu_hover_bg' => '#1b98e0',
			'color_menu_hover_text' => '#fff',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#1b98e0',
			'color_menu_button_bg' => '#1b98e0',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#1487ca',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#1b98e0',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#fff',
			'color_drop_hover_text' => '#1b98e0',
			'color_drop_active_bg' => '#1487ca',
			'color_drop_active_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f2f2',
			'color_content_border' => '#e5e5e5',
			'color_content_heading' => '#333',
			'color_content_text' => '#333',
			'color_content_link' => '#1b98e0',
			'color_content_link_hover' => '#004e7a',
			'color_content_primary' => '#1b98e0',
			'color_content_secondary' => '#004e7a',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f2f2f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#333',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#1b98e0',
			'color_alt_content_link_hover' => '#004e7a',
			'color_alt_content_primary' => '#1b98e0',
			'color_alt_content_secondary' => '#004e7a',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#333',
			'color_subfooter_bg_alt' => '#292929',
			'color_subfooter_border' => '#444',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#e5e5e5',
			'color_subfooter_link_hover' => '#1b98e0',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f2f2f2',
			'color_footer_border' => '#e5e5e5',
			'color_footer_text' => '#777',
			'color_footer_link' => '#1b98e0',
			'color_footer_link_hover' => '#004e7a',
		),
	),
	'3' => array(
		'title' => __( 'White Yellow', 'us' ),
		'values' => array(
			'color_body_bg' => '#f2f1f0',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#f9a02c',
			'color_chrome_toolbar' => '#f6f6f6',
			'color_header_top_bg' => '#f6f6f6',
			'color_header_top_text' => '#666',
			'color_header_top_text_hover' => '#f9a02c',
			'color_header_bottom_bg' => '#f6f6f6',
			'color_header_bottom_text' => '#666',
			'color_header_bottom_text_hover' => '#f9a02c',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#f9a02c',
			'color_header_search_bg' => '#f6f6f6',
			'color_header_search_text' => '#333',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#f9a02c',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#f9a02c',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#f9a02c',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#333',
			'color_drop_hover_bg' => '#f9a02c',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#f9a02c',
			'color_menu_button_bg' => '#f9a02c',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#333',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#ebebeb',
			'color_content_heading' => '#000',
			'color_content_text' => '#333',
			'color_content_link' => '#f9a02c',
			'color_content_link_hover' => '#000',
			'color_content_primary' => '#f9a02c',
			'color_content_secondary' => '#333',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f6f6f6',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e5e5e5',
			'color_alt_content_heading' => '#000',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#f9a02c',
			'color_alt_content_link_hover' => '#000',
			'color_alt_content_primary' => '#f9a02c',
			'color_alt_content_secondary' => '#333',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#f6f6f6',
			'color_subfooter_bg_alt' => '#fff',
			'color_subfooter_border' => '#e2e2e2',
			'color_subfooter_text' => '#666',
			'color_subfooter_link' => '#f9a02c',
			'color_subfooter_link_hover' => '#000',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f6f6f6',
			'color_footer_border' => '#ebebeb',
			'color_footer_text' => '#999',
			'color_footer_link' => '#666',
			'color_footer_link_hover' => '#f9a02c',
		),
	),
	'22' => array(
		'title' => __( 'White Azure', 'us' ),
		'values' => array(
			'color_body_bg' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#3b3d40',
			'color_header_middle_text_hover' => '#277cea',
			'color_chrome_toolbar' => '#fff',
			'color_header_top_bg' => '#fff',
			'color_header_top_text' => '#666d70',
			'color_header_top_text_hover' => '#277cea',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#666d70',
			'color_header_bottom_text_hover' => '#277cea',
			'color_header_transparent_text' => '#3b3d40',
			'color_header_transparent_text_hover' => '#277cea',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#3b3d40',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#277cea',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#277cea',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#277cea',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#3b3d40',
			'color_drop_hover_bg' => '#277cea',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#277cea',
			'color_menu_button_bg' => '#277cea',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#3b3d40',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#eee',
			'color_content_border' => '#eee',
			'color_content_heading' => '#3b3d40',
			'color_content_text' => '#3b3d40',
			'color_content_link' => '#277cea',
			'color_content_link_hover' => '#3b3d40',
			'color_content_primary' => '#277cea',
			'color_content_secondary' => '#3b3d40',
			'color_content_faded' => '#9da6a8',
			'color_alt_content_bg' => '#eee',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#3b3d40',
			'color_alt_content_text' => '#3b3d40',
			'color_alt_content_link' => '#277cea',
			'color_alt_content_link_hover' => '#3b3d40',
			'color_alt_content_primary' => '#277cea',
			'color_alt_content_secondary' => '#3b3d40',
			'color_alt_content_faded' => '#9da6a8',
			'color_subfooter_bg' => '#27282a',
			'color_subfooter_bg_alt' => '#323336',
			'color_subfooter_border' => '#3b3d40',
			'color_subfooter_text' => '#666d70',
			'color_subfooter_link' => '#9da6a8',
			'color_subfooter_link_hover' => '#277cea',
			'color_footer_bg' => '#27282a',
			'color_footer_bg_alt' => '#323336',
			'color_footer_border' => '#3b3d40',
			'color_footer_text' => '#666d70',
			'color_footer_link' => '#9da6a8',
			'color_footer_link_hover' => '#277cea',
		),
	),
	'4' => array(
		'title' => __( 'White Alizarin', 'us' ),
		'values' => array(
			'color_body_bg' => '#fe4641',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#444',
			'color_header_middle_text_hover' => '#fda527',
			'color_chrome_toolbar' => '#fe4641',
			'color_header_top_bg' => '#fe4641',
			'color_header_top_text' => 'rgba(255,255,255,0.75)',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#fe4641',
			'color_header_bottom_text' => 'rgba(255,255,255,0.75)',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fda527',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#444',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#fda527',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#fda527',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#fe4641',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#444',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#fda527',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#fe4641',
			'color_menu_button_bg' => '#fe4641',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#fda527',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#e5e5e5',
			'color_content_heading' => '#222',
			'color_content_text' => '#444',
			'color_content_link' => '#fe4641',
			'color_content_link_hover' => '#fda527',
			'color_content_primary' => '#fe4641',
			'color_content_secondary' => '#fda527',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#222',
			'color_alt_content_text' => '#444',
			'color_alt_content_link' => '#fe4641',
			'color_alt_content_link_hover' => '#fda527',
			'color_alt_content_primary' => '#fe4641',
			'color_alt_content_secondary' => '#fda527',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#252525',
			'color_subfooter_bg_alt' => '#1c1c1c',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#ddd',
			'color_subfooter_link_hover' => '#fda527',
			'color_footer_bg' => '#181818',
			'color_footer_bg_alt' => '#252525',
			'color_footer_border' => '#252525',
			'color_footer_text' => '#666',
			'color_footer_link' => '#aaa',
			'color_footer_link_hover' => '#fda527',
		),
	),
	'5' => array(
		'title' => __( 'White Sand', 'us' ),
		'values' => array(
			'color_body_bg' => '#f2f2f0',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#423b38',
			'color_header_middle_text_hover' => '#daa48a',
			'color_chrome_toolbar' => '#f2f2f0',
			'color_header_top_bg' => '#f2f2f0',
			'color_header_top_text' => '#777',
			'color_header_top_text_hover' => '#daa48a',
			'color_header_bottom_bg' => '#f2f2f0',
			'color_header_bottom_text' => '#777',
			'color_header_bottom_text_hover' => '#daa48a',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#f2f2f0',
			'color_header_search_text' => '#777',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#daa48a',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#daa48a',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#daa48a',
			'color_menu_button_bg' => '#daa48a',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#423b38',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#423b38',
			'color_drop_hover_bg' => '#daa48a',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#daa48a',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f2f0',
			'color_content_border' => '#e8e5e1',
			'color_content_heading' => '#423b38',
			'color_content_text' => '#423b38',
			'color_content_link' => '#daa48a',
			'color_content_link_hover' => '#423b38',
			'color_content_primary' => '#daa48a',
			'color_content_secondary' => '#423b38',
			'color_content_faded' => '#8f8b88',
			'color_alt_content_bg' => '#f2f2f0',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e8e5e1',
			'color_alt_content_heading' => '#423b38',
			'color_alt_content_text' => '#423b38',
			'color_alt_content_link' => '#daa48a',
			'color_alt_content_link_hover' => '#423b38',
			'color_alt_content_primary' => '#daa48a',
			'color_alt_content_secondary' => '#423b38',
			'color_alt_content_faded' => '#8f8b88',
			'color_subfooter_bg' => '#423b38',
			'color_subfooter_bg_alt' => '#21201e',
			'color_subfooter_border' => '#4d4a49',
			'color_subfooter_text' => '#8f8b88',
			'color_subfooter_link' => '#ccc9c8',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#423b38',
			'color_footer_bg_alt' => '#21201e',
			'color_footer_border' => '#4d4a49',
			'color_footer_text' => '#8f8b88',
			'color_footer_link' => '#ccc9c8',
			'color_footer_link_hover' => '#fff',
		),
	),
	'6' => array(
		'title' => __( 'White Royal', 'us' ),
		'values' => array(
			'color_body_bg' => '#301c2a',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#66525f',
			'color_header_middle_text_hover' => '#f4a641',
			'color_chrome_toolbar' => '#921245',
			'color_header_top_bg' => '#921245',
			'color_header_top_text' => 'rgba(255,255,255,0.75)',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#921245',
			'color_header_bottom_text' => 'rgba(255,255,255,0.75)',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#f4a641',
			'color_header_search_bg' => '#921245',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#f4a641',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#f4a641',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#f4a641',
			'color_drop_bg' => '#921245',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#f4a641',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#f4a641',
			'color_menu_button_bg' => '#f4a641',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#921245',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#ebe6e9',
			'color_content_heading' => '#442b3d',
			'color_content_text' => '#66525f',
			'color_content_link' => '#f4a641',
			'color_content_link_hover' => '#921245',
			'color_content_primary' => '#f4a641',
			'color_content_secondary' => '#921245',
			'color_content_faded' => '#b39fac',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ded9dc',
			'color_alt_content_heading' => '#442b3d',
			'color_alt_content_text' => '#66525f',
			'color_alt_content_link' => '#f4a641',
			'color_alt_content_link_hover' => '#921245',
			'color_alt_content_primary' => '#f4a641',
			'color_alt_content_secondary' => '#921245',
			'color_alt_content_faded' => '#b39fac',
			'color_subfooter_bg' => '#301c2a',
			'color_subfooter_bg_alt' => '#442b3d',
			'color_subfooter_border' => '#442b3d',
			'color_subfooter_text' => '#b8a5b2',
			'color_subfooter_link' => '#f4a641',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#301c2a',
			'color_footer_bg_alt' => '#442b3d',
			'color_footer_border' => '#442b3d',
			'color_footer_text' => '#b8a5b2',
			'color_footer_link' => '#f4a641',
			'color_footer_link_hover' => '#fff',
		),
	),
	'7' => array(
		'title' => __( 'Fresh Mint', 'us' ),
		'values' => array(
			'color_body_bg' => '#e3e8e8',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#303640',
			'color_header_middle_text_hover' => '#00bf80',
			'color_chrome_toolbar' => '#f2f3f5',
			'color_header_top_bg' => '#f2f3f5',
			'color_header_top_text' => '#7c8491',
			'color_header_top_text_hover' => '#00bf80',
			'color_header_bottom_bg' => '#f2f3f5',
			'color_header_bottom_text' => '#7c8491',
			'color_header_bottom_text_hover' => '#00bf80',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#f2f3f5',
			'color_header_search_text' => '#303640',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#00bf80',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#00bf80',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#00bf80',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#303640',
			'color_drop_hover_bg' => '#00bf80',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#00bf80',
			'color_menu_button_bg' => '#00bf80',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#33bbff',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f3f5',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#303640',
			'color_content_text' => '#303640',
			'color_content_link' => '#00bf80',
			'color_content_link_hover' => '#33bbff',
			'color_content_primary' => '#00bf80',
			'color_content_secondary' => '#33bbff',
			'color_content_faded' => '#7c8491',
			'color_alt_content_bg' => '#f2f3f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#303640',
			'color_alt_content_text' => '#303640',
			'color_alt_content_link' => '#00bf80',
			'color_alt_content_link_hover' => '#33bbff',
			'color_alt_content_primary' => '#00bf80',
			'color_alt_content_secondary' => '#33bbff',
			'color_alt_content_faded' => '#7c8491',
			'color_subfooter_bg' => '#434955',
			'color_subfooter_bg_alt' => '#303640',
			'color_subfooter_border' => '#545a66',
			'color_subfooter_text' => '#aab2bd',
			'color_subfooter_link' => '#d7dde0',
			'color_subfooter_link_hover' => '#33bbff',
			'color_footer_bg' => '#545a66',
			'color_footer_bg_alt' => '#434955',
			'color_footer_border' => '#676f7c',
			'color_footer_text' => '#d7dde0',
			'color_footer_link' => '#fff',
			'color_footer_link_hover' => '#33bbff',
		),
	),
	'21' => array(
		'title' => __( 'White Purple', 'us' ),
		'values' => array(
			'color_body_bg' => '#f6f6f6',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#4e4e4e',
			'color_header_middle_text_hover' => '#ffc80a',
			'color_chrome_toolbar' => '#f6f6f6',
			'color_header_top_bg' => '#f6f6f6',
			'color_header_top_text' => '#9fa3a7',
			'color_header_top_text_hover' => '#ffc80a',
			'color_header_bottom_bg' => '#f6f6f6',
			'color_header_bottom_text' => '#4e4e4e',
			'color_header_bottom_text_hover' => '#ffc80a',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ffc80a',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#4e4e4e',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#ffc80a',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#ffc80a',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#ffc80a',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#4e4e4e',
			'color_drop_hover_bg' => '#ffc80a',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#ffc80a',
			'color_menu_button_bg' => '#ffc80a',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#8a71b8',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#dedede',
			'color_content_heading' => '#242424',
			'color_content_text' => '#4e4e4e',
			'color_content_link' => '#8a71b8',
			'color_content_link_hover' => '#ffc80a',
			'color_content_primary' => '#8a71b8',
			'color_content_secondary' => '#ffc80a',
			'color_content_faded' => '#9fa3a7',
			'color_alt_content_bg' => '#f6f6f6',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#dedede',
			'color_alt_content_heading' => '#242424',
			'color_alt_content_text' => '#4e4e4e',
			'color_alt_content_link' => '#8a71b8',
			'color_alt_content_link_hover' => '#ffc80a',
			'color_alt_content_primary' => '#8a71b8',
			'color_alt_content_secondary' => '#ffc80a',
			'color_alt_content_faded' => '#9fa3a7',
			'color_subfooter_bg' => '#2c2c2c',
			'color_subfooter_bg_alt' => '#353535',
			'color_subfooter_border' => '#424242',
			'color_subfooter_text' => '#6c6c6c',
			'color_subfooter_link' => '#9fa3a7',
			'color_subfooter_link_hover' => '#ffc80a',
			'color_footer_bg' => '#2c2c2c',
			'color_footer_bg_alt' => '#353535',
			'color_footer_border' => '#424242',
			'color_footer_text' => '#6c6c6c',
			'color_footer_link' => '#9fa3a7',
			'color_footer_link_hover' => '#ffc80a',
		),
	),
	'8' => array(
		'title' => __( 'Black & White', 'us' ),
		'values' => array(
			'color_body_bg' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#666',
			'color_header_middle_text_hover' => '#000',
			'color_chrome_toolbar' => '#f6f6f6',
			'color_header_top_bg' => '#f6f6f6',
			'color_header_top_text' => '#666',
			'color_header_top_text_hover' => '#000',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#666',
			'color_header_bottom_text_hover' => '#000',
			'color_header_transparent_text' => 'rgba(255,255,255,0.66)',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#000',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#fff',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#000',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#000',
			'color_drop_bg' => '#fff',
			'color_drop_text' => '#666',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#000',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#000',
			'color_menu_button_bg' => '#666',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#000',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#ebebeb',
			'color_content_heading' => '#000',
			'color_content_text' => '#666',
			'color_content_link' => '#000',
			'color_content_link_hover' => '#000',
			'color_content_primary' => '#000',
			'color_content_secondary' => '#000',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#222',
			'color_alt_content_bg_alt' => '#000',
			'color_alt_content_border' => '#444',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#999',
			'color_alt_content_link' => '#fff',
			'color_alt_content_link_hover' => '#fff',
			'color_alt_content_primary' => '#fff',
			'color_alt_content_secondary' => '#fff',
			'color_alt_content_faded' => '#666',
			'color_subfooter_bg' => '#fff',
			'color_subfooter_bg_alt' => '#f6f6f6',
			'color_subfooter_border' => '#ebebeb',
			'color_subfooter_text' => '#666',
			'color_subfooter_link' => '#000',
			'color_subfooter_link_hover' => '#000',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f6f6f6',
			'color_footer_border' => '#ebebeb',
			'color_footer_text' => '#666',
			'color_footer_link' => '#000',
			'color_footer_link_hover' => '#000',
		),
	),
	'9' => array(
		'title' => __( 'Retro Package', 'us' ),
		'values' => array(
			'color_body_bg' => '#d9cfb8',
			'color_header_middle_bg' => '#4e4540',
			'color_header_middle_text' => '#f7f4ed',
			'color_header_middle_text_hover' => '#47bbca',
			'color_chrome_toolbar' => '#3d3632',
			'color_header_top_bg' => '#3d3632',
			'color_header_top_text' => '#f7f4ed',
			'color_header_top_text_hover' => '#47bbca',
			'color_header_bottom_bg' => '#3d3632',
			'color_header_bottom_text' => '#f7f4ed',
			'color_header_bottom_text_hover' => '#47bbca',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#47bbca',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#f26c51',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#f7f4ed',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#f26c51',
			'color_drop_bg' => '#4e4540',
			'color_drop_text' => '#f7f4ed',
			'color_drop_hover_bg' => '#3d3632',
			'color_drop_hover_text' => '#f7f4ed',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#f26c51',
			'color_menu_button_bg' => '#f26c51',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#47bbca',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#f7f4ed',
			'color_content_bg_alt' => '#edeae4',
			'color_content_border' => '#e5e1d7',
			'color_content_heading' => '#4e4540',
			'color_content_text' => '#4e4540',
			'color_content_link' => '#f26c51',
			'color_content_link_hover' => '#47bbca',
			'color_content_primary' => '#f26c51',
			'color_content_secondary' => '#47bbca',
			'color_content_faded' => '#99948a',
			'color_alt_content_bg' => '#edeae4',
			'color_alt_content_bg_alt' => '#f7f4ed',
			'color_alt_content_border' => '#dbd5ca',
			'color_alt_content_heading' => '#4e4540',
			'color_alt_content_text' => '#4e4540',
			'color_alt_content_link' => '#f26c51',
			'color_alt_content_link_hover' => '#47bbca',
			'color_alt_content_primary' => '#f26c51',
			'color_alt_content_secondary' => '#47bbca',
			'color_alt_content_faded' => '#99948a',
			'color_subfooter_bg' => '#4e4540',
			'color_subfooter_bg_alt' => '#3d3632',
			'color_subfooter_border' => '#5c524d',
			'color_subfooter_text' => '#ada29a',
			'color_subfooter_link' => '#f26c51',
			'color_subfooter_link_hover' => '#47bbca',
			'color_footer_bg' => '#3d3632',
			'color_footer_bg_alt' => '#4e4540',
			'color_footer_border' => '#5c524d',
			'color_footer_text' => '#978f8a',
			'color_footer_link' => '#c4b8b1',
			'color_footer_link_hover' => '#47bbca',
		),
	),
	'10' => array(
		'title' => __( 'Red Modern', 'us' ),
		'values' => array(
			'color_body_bg' => '#2b2c36',
			'color_header_middle_bg' => '#2b2c36',
			'color_header_middle_text' => '#edf0f2',
			'color_header_middle_text_hover' => '#ff2b58',
			'color_chrome_toolbar' => '#2b2c36',
			'color_header_top_bg' => '#2b2c36',
			'color_header_top_text' => '#d3d8db',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#2b2c36',
			'color_header_bottom_text' => '#d3d8db',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ff2b58',
			'color_header_search_bg' => '#fff',
			'color_header_search_text' => '#2b2c36',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#ff2b58',
			'color_menu_hover_bg' => '#23252a',
			'color_menu_hover_text' => '#ff2b58',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#ff2b58',
			'color_menu_button_bg' => '#ff2b58',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#6b748b',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#23252a',
			'color_drop_text' => '#edf0f2',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#ff2b58',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#ff2b58',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#dce0e3',
			'color_content_heading' => '#2b2c36',
			'color_content_text' => '#4e5663',
			'color_content_link' => '#ff2b58',
			'color_content_link_hover' => '#6b748b',
			'color_content_primary' => '#ff2b58',
			'color_content_secondary' => '#6b748b',
			'color_content_faded' => '#9698a3',
			'color_alt_content_bg' => '#2b2c36',
			'color_alt_content_bg_alt' => '#363845',
			'color_alt_content_border' => '#4e5663',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#f2f4f5',
			'color_alt_content_link' => '#ff2b58',
			'color_alt_content_link_hover' => '#6b748b',
			'color_alt_content_primary' => '#ff2b58',
			'color_alt_content_secondary' => '#6b748b',
			'color_alt_content_faded' => '#9698a3',
			'color_subfooter_bg' => '#2b2c36',
			'color_subfooter_bg_alt' => '#363845',
			'color_subfooter_border' => '#4e5663',
			'color_subfooter_text' => '#9698a3',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#ff2b58',
			'color_footer_bg' => '#2b2c36',
			'color_footer_bg_alt' => '#363845',
			'color_footer_border' => '#4e5663',
			'color_footer_text' => '#9698a3',
			'color_footer_link' => '#fff',
			'color_footer_link_hover' => '#ff2b58',
		),
	),
	'11' => array(
		'title' => __( 'Nautical Knot', 'us' ),
		'values' => array(
			'color_body_bg' => '#2c3e50',
			'color_header_middle_bg' => '#2c3e50',
			'color_header_middle_text' => '#edf0f2',
			'color_header_middle_text_hover' => '#fc4349',
			'color_chrome_toolbar' => '#384b5f',
			'color_header_top_bg' => '#384b5f',
			'color_header_top_text' => '#ced6de',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#384b5f',
			'color_header_bottom_text' => '#ced6de',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fc4349',
			'color_header_search_bg' => '#43a9d1',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#43a9d1',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#fc4349',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#43a9d1',
			'color_drop_bg' => '#2c3e50',
			'color_drop_text' => '#edf0f2',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#fc4349',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#43a9d1',
			'color_menu_button_bg' => '#43a9d1',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#fc4349',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#e4e8eb',
			'color_content_heading' => '#2c3e50',
			'color_content_text' => '#46515c',
			'color_content_link' => '#43a9d1',
			'color_content_link_hover' => '#fc4349',
			'color_content_primary' => '#43a9d1',
			'color_content_secondary' => '#fc4349',
			'color_content_faded' => '#9aa7b5',
			'color_alt_content_bg' => '#f2f4f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e3e6e8',
			'color_alt_content_heading' => '#2c3e50',
			'color_alt_content_text' => '#46515c',
			'color_alt_content_link' => '#43a9d1',
			'color_alt_content_link_hover' => '#fc4349',
			'color_alt_content_primary' => '#43a9d1',
			'color_alt_content_secondary' => '#fc4349',
			'color_alt_content_faded' => '#9aa7b5',
			'color_subfooter_bg' => '#2c3e50',
			'color_subfooter_bg_alt' => '#384b5f',
			'color_subfooter_border' => '#384b5f',
			'color_subfooter_text' => '#9aa7b5',
			'color_subfooter_link' => '#edf0f2',
			'color_subfooter_link_hover' => '#fc4349',
			'color_footer_bg' => '#384b5f',
			'color_footer_bg_alt' => '#2c3e50',
			'color_footer_border' => '#44586e',
			'color_footer_text' => '#9aa7b5',
			'color_footer_link' => '#edf0f2',
			'color_footer_link_hover' => '#fc4349',
		),
	),
	'12' => array(
		'title' => __( 'Mild Ocean', 'us' ),
		'values' => array(
			'color_body_bg' => '#d9dedd',
			'color_header_middle_bg' => '#29b28f',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#24a584',
			'color_header_top_bg' => '#24a584',
			'color_header_top_text' => '#cae5df',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#24a584',
			'color_header_bottom_text' => '#cae5df',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#b2ffee',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#24a584',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#fff',
			'color_menu_hover_bg' => '#24a584',
			'color_menu_hover_text' => '#fff',
			'color_menu_active_bg' => '#24a584',
			'color_menu_active_text' => '#fff',
			'color_drop_bg' => '#24a584',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#fff',
			'color_drop_hover_text' => '#29b28f',
			'color_drop_active_bg' => '#1e9879',
			'color_drop_active_text' => '#fff',
			'color_menu_button_bg' => '#fff',
			'color_menu_button_text' => '#0190a8',
			'color_menu_button_hover_bg' => '#0190a8',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f0f5f5',
			'color_content_border' => '#dfe8e8',
			'color_content_heading' => '#2b3233',
			'color_content_text' => '#5c6566',
			'color_content_link' => '#29b28f',
			'color_content_link_hover' => '#0190a8',
			'color_content_primary' => '#29b28f',
			'color_content_secondary' => '#0190a8',
			'color_content_faded' => '#a4b1b3',
			'color_alt_content_bg' => '#f0f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d0d6d6',
			'color_alt_content_heading' => '#2b3233',
			'color_alt_content_text' => '#5c6566',
			'color_alt_content_link' => '#29b28f',
			'color_alt_content_link_hover' => '#0190a8',
			'color_alt_content_primary' => '#29b28f',
			'color_alt_content_secondary' => '#0190a8',
			'color_alt_content_faded' => '#a4b1b3',
			'color_subfooter_bg' => '#445a58',
			'color_subfooter_bg_alt' => '#3a4e4c',
			'color_subfooter_border' => '#556b69',
			'color_subfooter_text' => '#c9d1d0',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#3a4e4c',
			'color_footer_bg_alt' => '#445a58',
			'color_footer_border' => '#556b69',
			'color_footer_text' => '#9ea9a8',
			'color_footer_link' => '#c9d1d0',
			'color_footer_link_hover' => '#fff',
		),
	),
	'13' => array(
		'title' => __( 'Midnight Red', 'us' ),
		'values' => array(
			'color_body_bg' => '#e3e6e8',
			'color_header_middle_bg' => '#363b3f',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#e14d43',
			'color_chrome_toolbar' => '#25282b',
			'color_header_top_bg' => '#25282b',
			'color_header_top_text' => '#c2c4c5',
			'color_header_top_text_hover' => '#e14d43',
			'color_header_bottom_bg' => '#25282b',
			'color_header_bottom_text' => '#c2c4c5',
			'color_header_bottom_text_hover' => '#e14d43',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#e14d43',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#ff887f',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#e14d43',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#e14d43',
			'color_menu_button_bg' => '#e14d43',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#fff',
			'color_menu_button_hover_text' => '#e14d43',
			'color_drop_bg' => '#363b3f',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#e14d43',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#e14d43',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf0f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#25282b',
			'color_content_text' => '#363b3f',
			'color_content_link' => '#e14d43',
			'color_content_link_hover' => '#69a8bb',
			'color_content_primary' => '#e14d43',
			'color_content_secondary' => '#69a8bb',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf0f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#25282b',
			'color_alt_content_text' => '#363b3f',
			'color_alt_content_link' => '#e14d43',
			'color_alt_content_link_hover' => '#69a8bb',
			'color_alt_content_primary' => '#e14d43',
			'color_alt_content_secondary' => '#69a8bb',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#363b3f',
			'color_subfooter_bg_alt' => '#2f3438',
			'color_subfooter_border' => '#494e52',
			'color_subfooter_text' => '#999c9f',
			'color_subfooter_link' => '#c2c4c5',
			'color_subfooter_link_hover' => '#69a8bb',
			'color_footer_bg' => '#25282b',
			'color_footer_bg_alt' => '#2f3438',
			'color_footer_border' => '#363b3f',
			'color_footer_text' => '#7a7f83',
			'color_footer_link' => '#c2c4c5',
			'color_footer_link_hover' => '#69a8bb',
		),
	),
	'14' => array(
		'title' => __( 'Stylish Cyan', 'us' ),
		'values' => array(
			'color_body_bg' => '#ddd',
			'color_header_middle_bg' => '#1a1a1a',
			'color_header_middle_text' => '#ddd',
			'color_header_middle_text_hover' => '#32beeb',
			'color_chrome_toolbar' => '#222',
			'color_header_top_bg' => '#222',
			'color_header_top_text' => '#999',
			'color_header_top_text_hover' => '#32beeb',
			'color_header_bottom_bg' => '#222',
			'color_header_bottom_text' => '#999',
			'color_header_bottom_text_hover' => '#32beeb',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#32beeb',
			'color_header_search_bg' => '#32beeb',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#32beeb',
			'color_menu_hover_bg' => '#32beeb',
			'color_menu_hover_text' => '#fff',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#32beeb',
			'color_menu_button_bg' => '#32beeb',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#28aad4',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#32beeb',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#1a1a1a',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => '#28aad4',
			'color_drop_active_text' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf1f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#222',
			'color_content_text' => '#444',
			'color_content_link' => '#32beeb',
			'color_content_link_hover' => '#666',
			'color_content_primary' => '#32beeb',
			'color_content_secondary' => '#666',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf1f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#222',
			'color_alt_content_text' => '#444',
			'color_alt_content_link' => '#32beeb',
			'color_alt_content_link_hover' => '#666',
			'color_alt_content_primary' => '#32beeb',
			'color_alt_content_secondary' => '#666',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#1a1a1a',
			'color_subfooter_bg_alt' => '#222',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#777',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#32beeb',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#1a1a1a',
			'color_footer_border' => '#333',
			'color_footer_text' => '#666',
			'color_footer_link' => '#bbb',
			'color_footer_link_hover' => '#32beeb',
		),
	),
	'15' => array(
		'title' => __( 'Light Ocean', 'us' ),
		'values' => array(
			'color_body_bg' => '#87a8a5',
			'color_header_middle_bg' => '#738e96',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#b2dab5',
			'color_chrome_toolbar' => '#627c83',
			'color_header_top_bg' => '#627c83',
			'color_header_top_text' => '#d5dddf',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#627c83',
			'color_header_bottom_text' => '#d5dddf',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#b2dab5',
			'color_header_search_text' => '#38505c',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#b2dab5',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#b2dab5',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#b2dab5',
			'color_menu_button_bg' => '#b2dab5',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#aa9d88',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#738e96',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#627c83',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => '#627c83',
			'color_drop_active_text' => '#b2dab5',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf1f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#38505c',
			'color_content_text' => '#505c5f',
			'color_content_link' => '#9ebaa0',
			'color_content_link_hover' => '#aa9d88',
			'color_content_primary' => '#9ebaa0',
			'color_content_secondary' => '#aa9d88',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf1f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#38505c',
			'color_alt_content_text' => '#505c5f',
			'color_alt_content_link' => '#9ebaa0',
			'color_alt_content_link_hover' => '#aa9d88',
			'color_alt_content_primary' => '#9ebaa0',
			'color_alt_content_secondary' => '#aa9d88',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#738e96',
			'color_subfooter_bg_alt' => '#627c83',
			'color_subfooter_border' => '#839da4',
			'color_subfooter_text' => '#d5dddf',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#627c83',
			'color_footer_bg_alt' => '#526a70',
			'color_footer_border' => '#738e96',
			'color_footer_text' => '#bbc5c7',
			'color_footer_link' => '#d5dddf',
			'color_footer_link_hover' => '#fff',
		),
	),
	'16' => array(
		'title' => __( 'Coffee Shop', 'us' ),
		'values' => array(
			'color_body_bg' => '#59524c',
			'color_header_middle_bg' => '#59524c',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#c7a589',
			'color_chrome_toolbar' => '#46403c',
			'color_header_top_bg' => '#46403c',
			'color_header_top_text' => '#cdcbc9',
			'color_header_top_text_hover' => '#c7a589',
			'color_header_bottom_bg' => '#46403c',
			'color_header_bottom_text' => '#cdcbc9',
			'color_header_bottom_text_hover' => '#c7a589',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#c7a589',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#c7a589',
			'color_menu_hover_bg' => '#46403c',
			'color_menu_hover_text' => '#fff',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#c7a589',
			'color_menu_button_bg' => '#c7a589',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#9ea476',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#46403c',
			'color_drop_text' => '#fff',
			'color_drop_hover_bg' => '#e5e3e1',
			'color_drop_hover_text' => '#46403c',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#c7a589',
			'color_content_bg' => '#f2f1f0',
			'color_content_bg_alt' => '#fff',
			'color_content_border' => '#e0dedc',
			'color_content_heading' => '#46403c',
			'color_content_text' => '#46403c',
			'color_content_link' => '#c7a589',
			'color_content_link_hover' => '#9ea476',
			'color_content_primary' => '#c7a589',
			'color_content_secondary' => '#9ea476',
			'color_content_faded' => '#979699',
			'color_alt_content_bg' => '#e5e3e1',
			'color_alt_content_bg_alt' => '#f2f1f0',
			'color_alt_content_border' => '#d6d4d2',
			'color_alt_content_heading' => '#46403c',
			'color_alt_content_text' => '#46403c',
			'color_alt_content_link' => '#c7a589',
			'color_alt_content_link_hover' => '#9ea476',
			'color_alt_content_primary' => '#c7a589',
			'color_alt_content_secondary' => '#9ea476',
			'color_alt_content_faded' => '#979699',
			'color_subfooter_bg' => '#59524c',
			'color_subfooter_bg_alt' => '#46403c',
			'color_subfooter_border' => '#69625c',
			'color_subfooter_text' => '#b1a9a2',
			'color_subfooter_link' => '#ddd6d0',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#46403c',
			'color_footer_bg_alt' => '#59524c',
			'color_footer_border' => '#69625c',
			'color_footer_text' => '#98918a',
			'color_footer_link' => '#b1a9a2',
			'color_footer_link_hover' => '#fff',
		),
	),
	'17' => array(
		'title' => __( 'Twilight', 'us' ),
		'values' => array(
			'color_body_bg' => '#38424a',
			'color_header_middle_bg' => '#21282e',
			'color_header_middle_text' => '#b0b6be',
			'color_header_middle_text_hover' => '#71a7d3',
			'color_chrome_toolbar' => '#1c2126',
			'color_header_top_bg' => '#1c2126',
			'color_header_top_text' => '#b0b6be',
			'color_header_top_text_hover' => '#937cbf',
			'color_header_bottom_bg' => '#1c2126',
			'color_header_bottom_text' => '#b0b6be',
			'color_header_bottom_text_hover' => '#937cbf',
			'color_header_transparent_text' => '#dadfe6',
			'color_header_transparent_text_hover' => '#fff',
			'color_header_search_bg' => '#71a7d3',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#71a7d3',
			'color_menu_hover_bg' => '#1c2126',
			'color_menu_hover_text' => '#b0b6be',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#71a7d3',
			'color_menu_button_bg' => '#71a7d3',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#937cbf',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#1c2126',
			'color_drop_text' => '#b0b6be',
			'color_drop_hover_bg' => '#71a7d3',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#71a7d3',
			'color_content_bg' => '#21282e',
			'color_content_bg_alt' => '#1c2126',
			'color_content_border' => '#303940',
			'color_content_heading' => '#d0d5db',
			'color_content_text' => '#bfc4c9',
			'color_content_link' => '#71a7d3',
			'color_content_link_hover' => '#937cbf',
			'color_content_primary' => '#71a7d3',
			'color_content_secondary' => '#937cbf',
			'color_content_faded' => '#757b83',
			'color_alt_content_bg' => '#1c2126',
			'color_alt_content_bg_alt' => '#21282e',
			'color_alt_content_border' => '#303940',
			'color_alt_content_heading' => '#d0d5db',
			'color_alt_content_text' => '#bfc4c9',
			'color_alt_content_link' => '#71a7d3',
			'color_alt_content_link_hover' => '#937cbf',
			'color_alt_content_primary' => '#71a7d3',
			'color_alt_content_secondary' => '#937cbf',
			'color_alt_content_faded' => '#757b83',
			'color_subfooter_bg' => '#1c2126',
			'color_subfooter_bg_alt' => '#21282e',
			'color_subfooter_border' => '#303940',
			'color_subfooter_text' => '#939aa2',
			'color_subfooter_link' => '#ccd0d4',
			'color_subfooter_link_hover' => '#937cbf',
			'color_footer_bg' => '#21282e',
			'color_footer_bg_alt' => '#1c2126',
			'color_footer_border' => '#303940',
			'color_footer_text' => '#939aa2',
			'color_footer_link' => '#ccd0d4',
			'color_footer_link_hover' => '#937cbf',
		),
	),
	'18' => array(
		'title' => __( 'Grey Turquoise', 'us' ),
		'values' => array(
			'color_body_bg' => '#222',
			'color_header_middle_bg' => '#444',
			'color_header_middle_text' => '#ccc',
			'color_header_middle_text_hover' => '#1abc9c',
			'color_chrome_toolbar' => '#393939',
			'color_header_top_bg' => '#393939',
			'color_header_top_text' => '#ccc',
			'color_header_top_text_hover' => '#1abc9c',
			'color_header_bottom_bg' => '#393939',
			'color_header_bottom_text' => '#ccc',
			'color_header_bottom_text_hover' => '#1abc9c',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#1abc9c',
			'color_header_search_bg' => '#1abc9c',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#1abc9c',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#1abc9c',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#1abc9c',
			'color_menu_button_bg' => '#1abc9c',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#fab908',
			'color_menu_button_hover_text' => '#fff',
			'color_drop_bg' => '#444',
			'color_drop_text' => '#ccc',
			'color_drop_hover_bg' => '#1abc9c',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#1abc9c',
			'color_content_bg' => '#444',
			'color_content_bg_alt' => '#393939',
			'color_content_border' => '#595959',
			'color_content_heading' => '#fff',
			'color_content_text' => '#ccc',
			'color_content_link' => '#1abc9c',
			'color_content_link_hover' => '#fab908',
			'color_content_primary' => '#1abc9c',
			'color_content_secondary' => '#fab908',
			'color_content_faded' => '#888',
			'color_alt_content_bg' => '#393939',
			'color_alt_content_bg_alt' => '#444',
			'color_alt_content_border' => '#444',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#ccc',
			'color_alt_content_link' => '#1abc9c',
			'color_alt_content_link_hover' => '#fab908',
			'color_alt_content_primary' => '#1abc9c',
			'color_alt_content_secondary' => '#fab908',
			'color_alt_content_faded' => '#888',
			'color_subfooter_bg' => '#303030',
			'color_subfooter_bg_alt' => '#282828',
			'color_subfooter_border' => '#444',
			'color_subfooter_text' => '#808080',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#fab908',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#282828',
			'color_footer_border' => '#333',
			'color_footer_text' => '#666',
			'color_footer_link' => '#aaa',
			'color_footer_link_hover' => '#fab908',
		),
	),
	'19' => array(
		'title' => __( 'City Hunter', 'us' ),
		'values' => array(
			'color_body_bg' => '#242d39',
			'color_header_middle_bg' => '#323f4f',
			'color_header_middle_text' => '#e8eff5',
			'color_header_middle_text_hover' => '#fd6861',
			'color_chrome_toolbar' => '#242d39',
			'color_header_top_bg' => '#242d39',
			'color_header_top_text' => '#b8c1cc',
			'color_header_top_text_hover' => '#8ed8f5',
			'color_header_bottom_bg' => '#242d39',
			'color_header_bottom_text' => '#b8c1cc',
			'color_header_bottom_text_hover' => '#8ed8f5',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#8ed8f5',
			'color_header_search_bg' => '#242d39',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#fd6861',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#8ed8f5',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#fd6861',
			'color_drop_bg' => '#242d39',
			'color_drop_text' => '#e8eff5',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#8ed8f5',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#fd6861',
			'color_menu_button_bg' => '#fd6861',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#e8eff5',
			'color_menu_button_hover_text' => '#242d39',
			'color_content_bg' => '#465568',
			'color_content_bg_alt' => '#323f4f',
			'color_content_border' => '#596b80',
			'color_content_heading' => '#fff',
			'color_content_text' => '#e8eff5',
			'color_content_link' => '#fd6861',
			'color_content_link_hover' => '#8ed8f5',
			'color_content_primary' => '#fd6861',
			'color_content_secondary' => '#8ed8f5',
			'color_content_faded' => '#7c8a97',
			'color_alt_content_bg' => '#323f4f',
			'color_alt_content_bg_alt' => '#465568',
			'color_alt_content_border' => '#465568',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#e8eff5',
			'color_alt_content_link' => '#fd6861',
			'color_alt_content_link_hover' => '#8ed8f5',
			'color_alt_content_primary' => '#fd6861',
			'color_alt_content_secondary' => '#8ed8f5',
			'color_alt_content_faded' => '#7c8a97',
			'color_subfooter_bg' => '#323f4f',
			'color_subfooter_bg_alt' => '#242d39',
			'color_subfooter_border' => '#414f61',
			'color_subfooter_text' => '#959eab',
			'color_subfooter_link' => '#cbcfd4',
			'color_subfooter_link_hover' => '#8ed8f5',
			'color_footer_bg' => '#242d39',
			'color_footer_bg_alt' => '#323f4f',
			'color_footer_border' => '#323f4f',
			'color_footer_text' => '#8a9099',
			'color_footer_link' => '#cbcfd4',
			'color_footer_link_hover' => '#8ed8f5',
		),
	),
	'20' => array(
		'title' => __( 'Black Gold', 'us' ),
		'values' => array(
			'color_body_bg' => '#2e2925',
			'color_header_middle_bg' => '#211e1b',
			'color_header_middle_text' => '#ccc4bc',
			'color_header_middle_text_hover' => '#f2ba66',
			'color_chrome_toolbar' => '#211e1b',
			'color_header_top_bg' => '#211e1b',
			'color_header_top_text' => '#ccc4bc',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#211e1b',
			'color_header_bottom_text' => '#ccc4bc',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#f2ba66',
			'color_header_search_bg' => '#211e1b',
			'color_header_search_text' => '#fff',
			'color_menu_transparent_active_bg' => 'transparent',
			'color_menu_transparent_active_text' => '#f2ba66',
			'color_menu_hover_bg' => 'transparent',
			'color_menu_hover_text' => '#f2ba66',
			'color_menu_active_bg' => 'transparent',
			'color_menu_active_text' => '#f2ba66',
			'color_drop_bg' => '#211e1b',
			'color_drop_text' => '#ccc4bc',
			'color_drop_hover_bg' => 'transparent',
			'color_drop_hover_text' => '#fff',
			'color_drop_active_bg' => 'transparent',
			'color_drop_active_text' => '#f2ba66',
			'color_menu_button_bg' => '#f2ba66',
			'color_menu_button_text' => '#fff',
			'color_menu_button_hover_bg' => '#2e2925',
			'color_menu_button_hover_text' => '#fff',
			'color_content_bg' => '#2e2925',
			'color_content_bg_alt' => '#211e1b',
			'color_content_border' => '#423c36',
			'color_content_heading' => '#fff',
			'color_content_text' => '#ccc4bc',
			'color_content_link' => '#f2ba66',
			'color_content_link_hover' => '#f2ba66',
			'color_content_primary' => '#f2ba66',
			'color_content_secondary' => '#f2ba66',
			'color_content_faded' => '#8c857e',
			'color_alt_content_bg' => '#211e1b',
			'color_alt_content_bg_alt' => '#2e2925',
			'color_alt_content_border' => '#423c36',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#ccc4bc',
			'color_alt_content_link' => '#f2ba66',
			'color_alt_content_link_hover' => '#f2ba66',
			'color_alt_content_primary' => '#f2ba66',
			'color_alt_content_secondary' => '#f2ba66',
			'color_alt_content_faded' => '#8c857e',
			'color_subfooter_bg' => '#211e1b',
			'color_subfooter_bg_alt' => '#2e2925',
			'color_subfooter_border' => '#423c36',
			'color_subfooter_text' => '#8c857e',
			'color_subfooter_link' => '#ccc4bc',
			'color_subfooter_link_hover' => '#f2ba66',
			'color_footer_bg' => '#211e1b',
			'color_footer_bg_alt' => '#2e2925',
			'color_footer_border' => '#423c36',
			'color_footer_text' => '#8c857e',
			'color_footer_link' => '#ccc4bc',
			'color_footer_link_hover' => '#f2ba66',
		),
	),
);
